﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="cu-paneltrabajo.ascx.vb" Inherits="Web.cu_paneltrabajo" %>
<%@ Register Src="~/private/traceability/Controles/cu-puestotrabajo.ascx" TagName="cu_puestotrabajo" TagPrefix="uc" %>
<%@ Register Src="~/private/traceability/Controles/cu-seleccionrecurso.ascx" TagName="cu_seleccionrecurso" TagPrefix="uc" %>

<asp:UpdatePanel runat="server" ID="UpdatePanelPanelTrabajo" UpdateMode="Conditional" ChildrenAsTriggers="false">
<ContentTemplate>

    <!-- Javascript -->
    <script type="text/javascript">

        // Ponemos el focus en el control de código de barras
        function SetFocus() {
                document.getElementById('<%=CodigoBarras.ClientID%>').focus();
            }

        function findGestures_workpanel() {
            var active = <%= GestureControlIsActiveForJs %>;
            if (active == false) {
                return;
            }
            setInterval(
                function () {
                    $.ajax({
                        type: "POST",
                        url: '../../../Services/GestureService.asmx/GetGestures',
                        data: '{jbcUser:"US00000001"}',
                        contentType: "application/json; charset=utf-8",
                        dataType: "json",
                        success: function (response) {
                            if (response.d.length === 0) {
                                return;
                            }

                            var gestures = response.d;
                            __doPostBack('ctl00$cu_paneltrabajo$BtnEnviar', '[' + gestures + ']');
                        },
                        failure: function (response) {
                            alert(response.d);
                        }
                    });
                },
                500);
        }
   
        findGestures_workpanel();
        window.onload = function () { SetFocus(); }

    </script>

    <!-- Panel de trabajo -->
    <div class="sidebar-item trace">
        <div class="add-panel panel-decorated panel-big">
            <div class="container">
                <div class="title-icon">
                    <i class="icon2-list"></i>
                </div>
                <h2><%= Translator.Translate("TRACE_WORKING_PANEL_HEADER")%></h2>
            </div>
        </div>
        <div class="work-panel">

            <asp:Repeater ID="repeater_panel_trabajo" runat="server">
                <ItemTemplate>
                    <div class="visual-block" style="padding:0px; margin-top:-5px;">
                        <div class="bordered-visual" id="divImagenOperario" runat="server">
                            <a href='<%# Eval("ImagenOperario")%>' class="visual-box image-lightbox">
                                <img src='<%# Eval("ImagenOperario")%>' width="70" height="70" alt="image description" runat="server" enableviewstate="true" style="max-height:65px; max-width:65px;"/>
                            </a>
                        </div>
                        <div class="bordered-visual" id="divImagenSoporteTrabajo" runat="server" visible='<%# Trim(CStr(Eval("ImagenSoporteTrabajo"))) <> String.Empty%>' style="margin-top:10px;">
                            <a href='<%# Eval("ImagenSoporteTrabajo")%>' class="visual-box image-lightbox">
                                <img src='<%# Eval("ImagenSoporteTrabajo")%>' width="118" height="77" alt="image description" runat="server" enableviewstate="true" />
                            </a>
                        </div>
                    </div>
                    <div class="info-block">
                        <div class="info-item">
                            <div class="visual-holder">
                                <i class="icon2-avatar-second"></i>
                            </div>
                            <div class="text-holder big">
                                <dl>
                                    <dt><%= Translator.Translate("TRACE_WORKING_PANEL_USERNAME")%></dt>
                                    <dd><%# Eval("Usuario")%></dd>
                                </dl>
                            </div>
                        </div>
                        <div class="info-item">
                            <div class="visual-holder">
                                <i class="icon2-pcb"></i>
                            </div>
                            <div class="text-holder big">
                                <dl>
                                    <dt><%= Translator.Translate("TRACE_WORKING_PANEL_WORK_SUPPORT")%></dt>
                                    <dd><%# Eval("SoporteTrabajo")%></dd>
                                </dl>
                            </div>
                        </div>
                        <div class="info-item">
                            <div class="visual-holder">
                                <i class="icon2-code"></i>
                            </div>
                            <div class="text-holder">
                                <dl>
                                    <dt><%= Translator.Translate("TRACE_WORKING_PANEL_BARCODE")%></dt>
                                    <dd></dd>
                                </dl>
                            </div>
                        </div>
                    </div>
                </ItemTemplate>
            </asp:Repeater>
            <div class="form-block">
                <div class="form-item">
                    <asp:TextBox ID="CodigoBarras" runat="server" name="CodigoBarras" TabIndex="1"></asp:TextBox>
                </div>
                <div class="form-item">
                    <asp:LinkButton ID="BtnEnviar" runat="server" CssClass="btn" OnClick="btn_Enviar_Click"><i class="icon2-arrow-right"></i></asp:LinkButton>
                </div>
                <div class="form-item">
                    <asp:LinkButton ID="BtnBorrar" runat="server" CssClass="btn btn-error" OnClick="btn_Borrar_Click"><i class="icon2-error"></i></asp:LinkButton>
                </div>
            </div>
        </div>
    </div>

    <!-- Panel de tarea actual -->
    <div id="divTareaActual" class="sidebar-item gallery-item trace" runat="server">
        <div class="add-panel panel-decorated panel-blue">
            <div class="container">
                <div class="title-icon" style="border: solid 0px #000;">
                    <i class="icon2-check-ready"></i>
                </div>
                <h2><%= Translator.Translate("TRACE_CURRENT_TASK_PANEL_HEADER")%> <strong>
                    <asp:Label ID="lblTareaActual" runat="server" Text=""></asp:Label></strong></h2>
                <img id="imgWarningRequisitos" src="~/App_Themes/Web/images/warning.png" runat="server" visible="false" width="30" height="30" class="tooltip" style="position: absolute; right: 6px; top: 8px; cursor: help;">
            </div>
        </div>

        <asp:UpdatePanel runat="server" ID="UpdatePanelTareaTiempoReal" UpdateMode="Conditional">
            <ContentTemplate>
                <div class="estimate-block">
                    <div class="estimate-content">
                        <div class="estimate-item">
                            <div class="estimate-item-inner">
                                <div class="items-block">
                                    <dl>
                                        <dt><%= Translator.Translate("TRACE_CURRENT_TASK_PANEL_STATE")%></dt>
                                        <dd><strong><asp:Label ID="lblEstadoTarea" runat="server" Text="Pendiente"></asp:Label></strong></dd>
                                    </dl>
                                    <dl>
                                        <dt><%= Translator.Translate("TRACE_CURRENT_TASK_PANEL_REAL_TIME")%></dt>
                                        <dd class="time"><strong><asp:Label ID="lblTareaTiempoReal" runat="server" Text="00:00:00"></asp:Label></strong></dd>
                                    </dl>
                                </div>
                                <div class="button-block">
                                    <asp:LinkButton CssClass="btn btn-inline" ID="btnFinalizarTarea" runat="server" Width="105px" OnClientClick="DisableControl(this);"><%= Translator.Translate("TRACE_CURRENT_TASK_PANEL_END_TASK")%></asp:LinkButton>
                                    <asp:LinkButton CssClass="btn btn-disabled btn-inline" ID="btnPosponerTarea" runat="server" Enabled="false" Width="105px" style="margin-left:10px" OnClientClick="DisableControl(this);"><%= Translator.Translate("TRACE_CURRENT_TASK_PANEL_POSTPONE_TASK")%></asp:LinkButton>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="buttons-box">
                        <asp:LinkButton CssClass="btn-next btn-disabled" ID="btnTareaSiguiente" runat="server" Enabled="false"></asp:LinkButton>
                        <asp:LinkButton CssClass="btn-prev btn-disabled" ID="btnTareaAnterior" runat="server" Enabled="false"></asp:LinkButton>
                    </div>
                </div>
                
                <!-- comentario de la tarea -->
                <asp:LinkButton ID="lnkComment" runat="server">
                    <asp:TextBox placeholder="Associated comment" ID="Comments" runat="server" Height="80" CssClass="input" Text="" Rows="3" TextMode="MultiLine" onclick=""></asp:TextBox>
                </asp:LinkButton>

                <!-- Timer tiempo real de la tarea -->
                <asp:Timer ID="TimerTareaTiempoReal" runat="server" Interval="1000" OnTick="TimerTareaTiempoReal_Tick" Enabled="false"></asp:Timer>

            </ContentTemplate>
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="TimerTareaTiempoReal" EventName="Tick" />
            </Triggers>
        </asp:UpdatePanel>

        <!-- Controles ajax -->
        <ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationTareaTiempoReal" TargetControlID="UpdatePanelTareaTiempoReal" BehaviorID="animation" runat="server">    
        <Animations>
            <OnUpdated>
                <Sequence>
                    <ScriptAction Script="UnlockScreen();" />
                </Sequence>
            </OnUpdated>
        </Animations>
        </ajaxToolkit:UpdatePanelAnimationExtender>

    </div>

    <!-- Streaming de video -->
    <div id="divWebRTC" runat="server">
        <video id="vid2" autoplay controls></video>
        <script type="text/javascript">
            window.onload = function () { connect('<%=ServerIP%>:9000'); }
        </script>
    </div>

    <!-- Panel de puertos reservados -->
    <div id="divPuertosReservados" class="sidebar-item gallery-item trace" runat="server">

        <div class="add-panel panel-decorated panel-blue">
            <div class="container">
                <div class="title-icon" style="border: solid 0px #000;"><i class="icon2-avatar"></i></div>
                <h2 runat="server" id="h2_numpuertosreservados">Puertos reservados: <strong>2</strong></h2>
            </div>
        </div>
        <div class="estimate-block">
            <asp:Repeater ID="repeater_puertos_reservados" runat="server">
                <ItemTemplate>
                    <div class="estimate-content">
                        <div class="estimate-item">
                            <div class="estimate-item-inner">
                                <div class="items-block">
                                    <dl>
                                        <dt><%= Translator.Translate("TRACE_RESERVED_PORTS_PANEL_STATION")%></dt>
                                        <dd><strong><%# If(Trim(CStr(Eval("InternalReference"))) = String.Empty, CStr(Eval("UUID")), CStr(Eval("InternalReference")))%></strong></dd>
                                    </dl>
                                    <dl>
                                        <dt><%= Translator.Translate("TRACE_RESERVED_PORTS_PANEL_PORT")%></dt>
                                        <dd><strong><%# Eval("Port")%></strong></dd>
                                    </dl>
                                </div>
                                <div class="button-block">
                                    <asp:LinkButton ID="btnPuertoReservadoLiberar" runat="server" CssClass="btn btn-inline" CommandName="PUERTORESERVADO_LIBERAR" CommandArgument='<%# Eval("CodeServer") & "#" & Eval("UUID") & "#" & Eval("Port")%>'><%= Translator.Translate("TRACE_RESERVED_PORTS_PANEL_RELEASE_PORT")%></asp:LinkButton>
                                </div>
                            </div>
                        </div>
                    </div>
                </ItemTemplate>
            </asp:Repeater>
            <div class="buttons-box">
                <asp:LinkButton ID="btnPuertoReservadoNext" runat="server" CssClass="btn-next"></asp:LinkButton>
                <asp:LinkButton ID="btnPuertoReservadoPrev" runat="server" CssClass="btn-prev"></asp:LinkButton>
            </div>
            <asp:HiddenField ID="PaginaActualPuertoReservado" runat="server" Value="0" />
        </div>

    </div>

    <!-- Control de usuario de selección de recurso -->
    <uc:cu_seleccionrecurso ID="cu_seleccionrecurso" runat="server" />

    <!-- Control de usuario de selección de puesto de trabajo -->
    <uc:cu_puestotrabajo ID="cu_puestotrabajo" runat="server" />

    <!--- Controles ocultos y timer-->
    <asp:HiddenField ID="hdnOrigen" runat="server" Value="" />
    <asp:HiddenField ID="hdnCodigoUsuario" runat="server" Value="" />
    <asp:HiddenField ID="hdnModoTrabajo" runat="server" Value="" />
    <asp:HiddenField ID="hdnCodigoServidorActualTrabajo" runat="server" Value="" />
    <asp:HiddenField ID="hdnEstacionActualTrabajo" runat="server" Value="" />
    <asp:HiddenField ID="hdnPuertoActualTrabajo" runat="server" Value="-1" />

</ContentTemplate>
</asp:UpdatePanel>

<!-- Updateprogress -->
<asp:UpdateProgress ID="UpdateProgressPanelTrabajo" runat="server" AssociatedUpdatePanelID="UpdatePanelPanelTrabajo" DisplayAfter="100">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_MenuStation" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" Style="z-index: 100002;" />
    </ProgressTemplate>
</asp:UpdateProgress>

<!-- UpdatePanelAnimation -->
<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationPanelTrabajo" TargetControlID="UpdatePanelPanelTrabajo" BehaviorID="animation" runat="server">
    <Animations>
        <OnUpdated>
            <Sequence>
                <ScriptAction Script="initRefreshFunctions($('div.trace')); findGestures_workpanel(); SetFocus();"  />
            </Sequence>
        </OnUpdated>
    </Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>

<!-- Panel de notificación que indica al usuario que una tarea está a punto de posponerse por límite de tiempo -->
<asp:UpdatePanel runat="server" Id="UpdatePanelContinueTask" UpdateMode="Conditional">
<ContentTemplate>

    <!--Panel de notificación que en breve se auto postpondrá una tarea -->
    <asp:Panel ID="PanelContinueTask" runat="server" Style="display:none" CssClass="error-message">
        <div class="holder">
            <asp:Image runat="server" Width="50" Height="50" ID="IdMsgImage_ContinueTask" style="min-width:50px;"  />
            <span style="min-width:250px;"><asp:Literal ID="InfoMsg_ContinueTask" runat="server" /> </span>
            <asp:LinkButton ID="LinkBtnAceptar_ContinueTask" CssClass="btn" runat="server" style="min-width:150px;"><%= Translator.Translate("TRACE_PANEL_POSTPONE_CONTINUE_TASK")%></asp:LinkButton>
            <asp:LinkButton ID="LinkBtnCancelar_ContinueTask" CssClass="btn" runat="server" Visible="False"><%= Translator.Translate("ADMIN_BTN_CLOSE")%></asp:LinkButton>
        </div>
    </asp:Panel>

    <!-- controles ajax-->
    <ajaxToolkit:ModalPopupExtender ID="MPE_PanelContinueTask" runat="server" TargetControlID="hdnPanelContinueTask" CancelControlID="LinkBtnCancelar_ContinueTask" PopupControlID="PanelContinueTask" BackgroundCssClass="" DropShadow="false" PopupDragHandleControlID=""/>
    
    <!-- controles ocultos-->
    <asp:HiddenField ID="hdnPanelContinueTask" runat="server" />

</ContentTemplate>

</asp:UpdatePanel>

<!-- Al cerrar la sesión se valida que no existan tareas en curso. -->
<asp:UpdatePanel runat="server" Id="UpdatePanelEndSessionOpenTasks" UpdateMode="Conditional">
    <ContentTemplate>

        <!--Panel de notificación de tareas en curso al querer cerrar sesión -->
        <asp:Panel ID="PanelEndSessionOpenTasks" runat="server" Style="display:none" CssClass="error-message">
            <div class="holder">
                <asp:Image runat="server" Width="50" Height="50" ID="IdMsgImage_EndSessionOpenTasks" style="min-width:50px;"  />
                <span style="min-width:250px;"><asp:Literal ID="InfoMsg_EndSessionOpenTasks" runat="server" /></span>
                <asp:TextBox placeholder="Associated comment" ID="CommentsEndSessionOpenTasks" runat="server" style="margin: 0 auto" Height="80" Width="400px" CssClass="input" Text="" Rows="3" TextMode="MultiLine" TabIndex="1" Visible="False"></asp:TextBox>
                <asp:RequiredFieldValidator  ID="reqValidatorCommentsEndSessionOpenTasks" ControlToValidate="CommentsEndSessionOpenTasks" ForeColor="#cc0000" Font-Bold="true"  MaximumValue="50" Text="Debe introducir un comentario" runat="server" ValidationGroup="CONTROLENTRADA"></asp:RequiredFieldValidator>
                <br/>
                <asp:LinkButton ID="LinkBtnFinalize_EndSessionOpenTasks" CommandName="FINALIZAR" CssClass="btn" runat="server" style="min-width:100px;" ValidationGroup="CONTROLENTRADA"><%= Translator.Translate("TRACE_PANEL_CLOSE_SESSION_END_TASK")%></asp:LinkButton>
                <asp:LinkButton ID="LinkBtnPostpone_EndSessionOpenTasks" CommandName="POSPONER" CssClass="btn" runat="server" style="min-width:100px;" ValidationGroup="CONTROLENTRADA"><%= Translator.Translate("TRACE_PANEL_CLOSE_SESSION_POSTPONE_TASK")%></asp:LinkButton>
                <asp:LinkButton ID="LinkBtnCancelar_EndSessionOpenTasks" CommandName="CANCELAR" CssClass="btn" runat="server" style="min-width:100px;"><%= Translator.Translate("ADMIN_BTN_CANCEL")%></asp:LinkButton>
            </div>
        </asp:Panel>

        <!-- controles ajax-->
        <ajaxToolkit:ModalPopupExtender ID="MPE_PanelEndSessionOpenTasks" runat="server" TargetControlID="hdnPanelEndSessionOpenTasks" CancelControlID="" PopupControlID="PanelEndSessionOpenTasks" BackgroundCssClass="" DropShadow="false" PopupDragHandleControlID=""/>
    
        <!-- controles ocultos-->
        <asp:HiddenField ID="hdnPanelEndSessionOpenTasks" runat="server" Value="" />

    </ContentTemplate>

</asp:UpdatePanel>